//
//  RecognitionViewController.m
//  Harding_MyOCR
//
//  Created by tamara7777 on 4/13/13.
//  Copyright (c) 2013 tamara7777. All rights reserved.
//

#import "RecognitionViewController.h"
#import "AppDelegate.h"

@implementation RecognitionViewController 

@synthesize textView;
@synthesize statusLabel;
@synthesize statusIndicator;
@synthesize myText=_myText;

#pragma mark - View lifecycle

- (void)viewDidLoad {
[super viewDidLoad];
NSFileManager *filemgr;
NSString *dataFile;
NSString *docsDir;
NSArray *dirPaths;

filemgr = [NSFileManager defaultManager];

// Identify the documents directory
dirPaths = NSSearchPathForDirectoriesInDomains(
                                               NSDocumentDirectory, NSUserDomainMask, YES);

docsDir = dirPaths[0];

// Build the path to the data file
dataFile = [docsDir stringByAppendingPathComponent:
            @"datafile.dat"];

// Check if the file already exists
if ([filemgr fileExistsAtPath: dataFile])
{
    // Read file contents and display in textBox
    NSData *databuffer;
    databuffer = [filemgr contentsAtPath: dataFile];
    
    NSString *datastring = [[NSString alloc]
                            initWithData: databuffer
                            encoding:NSASCIIStringEncoding];
    
    textView.text = datastring;
}
    
    
    
UINavigationItem *_save;
{
    NSFileManager *filemgr;
    NSData *databuffer;
    NSString *dataFile;
    NSString *docsDir;
    NSArray *dirPaths;
    
    filemgr = [NSFileManager defaultManager];
    
    dirPaths = NSSearchPathForDirectoriesInDomains(
                                                   NSDocumentDirectory, NSUserDomainMask, YES);
    
    docsDir = dirPaths[0];
    dataFile = [docsDir
                stringByAppendingPathComponent: @"datafile.dat"];
    databuffer = [textView.text
                  dataUsingEncoding: NSASCIIStringEncoding];
    [filemgr createFileAtPath: dataFile
                     contents: databuffer attributes:nil];

}
}

- (void)viewWillAppear:(BOOL)animated
{
	textView.hidden = YES;
	
	statusLabel.hidden = NO;
	statusIndicator. hidden = NO;
	
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
	statusLabel.text = @"Loading image...";
	
	UIImage* image = [(AppDelegate*)[[UIApplication sharedApplication] delegate] imageToProcess];
	
	Client *client = [[Client alloc] initWithApplicationID:@"Easy .csv" password:@"2ZhmUqmIRXMFWo6vVGKhEcss"];
	
	[client setDelegate:self];
	
	ProcessingParams* params = [[ProcessingParams alloc] init];
	
	[client processImage:image withParams:params];
	
	statusLabel.text = @"Uploading image...";
	
    [super viewDidAppear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
	return NO;
}

#pragma mark - ClientDelegate implementation

- (void)clientDidFinishUpload:(Client *)sender
{
	statusLabel.text = @"Processing image...";
}

- (void)clientDidFinishProcessing:(Client *)sender
{
	statusLabel.text = @"Downloading result...";
}

- (void)client:(Client *)sender didFinishDownloadData:(NSData *)downloadedData
{
	statusLabel.hidden = YES;
	statusIndicator.hidden = YES;
	
	textView.hidden = NO;
	
	NSString* result = [[NSString alloc] initWithData:downloadedData encoding:NSUTF8StringEncoding];
	
	textView.text = result;
}

- (void)client:(Client *)sender didFailedWithError:(NSError *)error
{
	UIAlertView* alert = [[UIAlertView alloc] initWithTitle:@"Error"
													message:[error localizedDescription]
												   delegate:self
										  cancelButtonTitle:@"Cancel"
										  otherButtonTitles:nil, nil];
	
	[alert show];
	
	statusLabel.text = [error localizedDescription];
	statusIndicator.hidden = YES;
}
-(NSString *)dataFilePath {
    
    NSArray *paths = NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES);
    
    NSString *documentsDirectory = [paths objectAtIndex:0];
    
    return [documentsDirectory stringByAppendingPathComponent:@"filename.text"];

}
- (IBAction)saveCSV:(id)sender {
    
    //could be a string of text like
    
    
    
    NSString *resultLine = [NSString stringWithFormat:@"%@,%@\n",_myName.text,_myEmail.text];
    
    
    
    NSString *docPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES)objectAtIndex:0];
    NSString *receipts = [docPath stringByAppendingPathComponent:@"results.csv"];
    if (![[NSFileManager defaultManager] fileExistsAtPath:receipts]){
        [[NSFileManager defaultManager] createFileAtPath:receipts contents:nil attributes:nil];
    }
    NSFileHandle *fileHandle = [NSFileHandle fileHandleForUpdatingAtPath:receipts];
    [fileHandle seekToEndOfFile];
    [fileHandle writeData:[resultLine dataUsingEncoding:NSUTF8StringEncoding]];
    [fileHandle closeFile];
    _myEmail.text = @"";
    _myName.text = @"";
    [_myName resignFirstResponder];
    [_myEmail resignFirstResponder];
    NSLog(@"Data Saved");
    
}

- (IBAction)showCSV:(id)sender {
    NSString *docPath = [NSSearchPathForDirectoriesInDomains(NSDocumentDirectory,NSUserDomainMask,YES)objectAtIndex:0];
    NSString *receipts  = [docPath stringByAppendingPathComponent:@"results.csv"];
    
    if([[NSFileManager defaultManager] fileExistsAtPath:receipts])
    {
        NSFileHandle *fileHandle = [NSFileHandle fileHandleForReadingAtPath:receipts];
        NSString *receiptResults = [[NSString alloc]initWithData:[fileHandle availableData] encoding:NSUTF8StringEncoding];
        
        _myText.text = receiptResults;
        [fileHandle closeFile];
        
        [_myName resignFirstResponder];
        [_myEmail resignFirstResponder];
    }
    
}












@end